﻿import matplotlib.pyplot as plt # importation du module pyplot de matplotlib qui sera nommé en abregé plt
import numpy as np
from math import*

# Données de chronophotographie
t =[0.000,0.033,0.067,0.1,0.133,0.167,0.2,0.233,0.267,0.3,0.333,0.367,0.4,0.433,0.467,0.5] 
x = [0.000,0.133,0.261,0.383,0.501,0.612,0.723,0.828,0.922,1.018,1.106,1.190,1.268,1.340,1.408,1.475]
y = [0.007,0.106,0.192,0.256,0.307,0.339,0.356,0.364,0.361,0.339,0.307,0.268,0.219,0.162,0.093,0.015]

m=1.3*10**-3 #masse de la balle en g
g=9.81 #intensite de pesanteur terrestre en m/s2

# Initialisation : création de trois listes vides correspondant à l'énergie potentielle et les vitesses suivant x et y
Ep=[]
vx=[]
vy=[]
for i in range(1,len(t)-1) :
    Ep.append()#a completer
    vx.append()#a completer
    vy.append()#a completer

# Initialisation : création de deux listes vides correspondant à l'énergie cinétique et mécanique
Ec=[]
Em=[]
for i in range(0,len(t)-2) :
    Ec.append()#a completer
    Em.append()#a completer

plt.grid()
plt.axis()
plt.title("Evolution temporelle des energies de la balle de polystyrene",fontweight='bold',color="black",fontsize=16)
plt.xlabel(('Temps (en s)'),fontweight='bold',fontsize=14)
plt.ylabel(('Energie (en J)'),fontweight='bold',fontsize=14)
plt.plot(t[1:-1],Ec,'go-',label='Energie cinetique')
plt.plot(t[1:-1],Ep,'b+-',label='Energie potentielle')
plt.plot(t[1:-1],Em,'r^-',label='Energie mecanique')
plt.legend(loc='upper right',fontsize=14)

plt.show()


